/**
  * # AWS - Resource Group
  * 
  * This a Terraform module for creating a resource group on AWS filtering on the `flowable-iac` tag.
  * See the documentation below for additional info on using this module.
  */
locals {
  rg_name = (var.name_override != "" ? "${var.name_override}" : "${var.full_workload}-rg")
}


# Create a resource group
resource "aws_resourcegroups_group" "rg" {
  name = local.rg_name

  resource_query {
    query = <<JSON
{ 
  "ResourceTypeFilters": ["AWS::AllSupported"],
  "TagFilters": [
    {
      "Key": "${var.workload}",
      "Values": ["${var.env_suffix}"]
    }
  ]
}
JSON
  }
}
