/**
  * # AWS - RDS Oracle Enterprise
  * 
  * This a Terraform module for creating a RDS Oracle Enterprise on AWS.
  * See the documentation below for additional info on using this module.
  */

locals {
  db_name_prefix = (var.name_prefix_override != "" ? "${var.name_prefix_override}" : "${var.full_workload}-db")
  flowable_db_username = jsondecode(data.aws_secretsmanager_secret_version.flowable_db_auth.secret_string)["flowable_db_username"]
  flowable_db_password = jsondecode(data.aws_secretsmanager_secret_version.flowable_db_auth.secret_string)["flowable_db_password"]
}

resource "aws_db_parameter_group" "flowable_db_oe" {
  name   = "${local.db_name_prefix}-pg"
  family = "oracle-ee-19"

  # parameter {
  #   name  = "log_connections"
  #   value = "1"
  # }
}

resource "aws_db_instance" "flowable_control_db" {
  count                  = var.flowable_control_enabled ? 1 : 0
  
  identifier             = "${local.db_name_prefix}-control"
  name                   = "CONTROL"
  instance_class         = var.flowable_control_db_instance_class
  allocated_storage      = var.flowable_control_db_allocated_storage
  engine                 = "oracle-ee"
  engine_version         = "19.0.0.0.ru-2021-07.rur-2021-07.r1"
  username               = local.flowable_db_username
  password               = local.flowable_db_password
  db_subnet_group_name   = var.vpc_database_subnet_group_name
  vpc_security_group_ids = [aws_security_group.database.id]
  parameter_group_name   = aws_db_parameter_group.flowable_db_oe.name
  publicly_accessible    = false
  skip_final_snapshot    = true
}

resource "aws_db_instance" "flowable_design_db" {
  count                  = var.flowable_design_enabled ? 1 : 0

  identifier             = "${local.db_name_prefix}-design"
  name                   = "DESIGN"
  instance_class         = var.flowable_design_db_instance_class
  allocated_storage      = var.flowable_design_db_allocated_storage
  engine                 = "oracle-ee"
  engine_version         = "19.0.0.0.ru-2021-07.rur-2021-07.r1"
  username               = local.flowable_db_username
  password               = local.flowable_db_password
  db_subnet_group_name   = var.vpc_database_subnet_group_name
  vpc_security_group_ids = [aws_security_group.database.id]
  parameter_group_name   = aws_db_parameter_group.flowable_db_oe.name
  publicly_accessible    = false
  skip_final_snapshot    = true
}

resource "aws_db_instance" "flowable_work_db" {
  count                  = var.flowable_work_enabled ? 1 : 0

  identifier             = "${local.db_name_prefix}-work"
  name                   = "WORK"
  instance_class         = var.flowable_work_db_instance_class
  allocated_storage      = var.flowable_work_db_allocated_storage
  engine                 = "oracle-ee"
  engine_version         = "19.0.0.0.ru-2021-07.rur-2021-07.r1"
  username               = local.flowable_db_username
  password               = local.flowable_db_password
  db_subnet_group_name   = var.vpc_database_subnet_group_name
  vpc_security_group_ids = [aws_security_group.database.id]
  parameter_group_name   = aws_db_parameter_group.flowable_db_oe.name
  publicly_accessible    = false
  skip_final_snapshot    = true
}

resource "aws_db_instance" "flowable_engage_db" {
  count                  = var.flowable_engage_enabled ? 1 : 0

  depends_on = [
    aws_security_group.database
  ]
  identifier             = "${local.db_name_prefix}-engage"
  name                   = "engage"
  instance_class         = var.flowable_engage_db_instance_class
  allocated_storage      = var.flowable_engage_db_allocated_storage
  engine                 = "oracle-ee"
  engine_version         = "19.0.0.0.ru-2021-07.rur-2021-07.r1"
  username               = local.flowable_db_username
  password               = local.flowable_db_password
  db_subnet_group_name   = var.vpc_database_subnet_group_name
  vpc_security_group_ids = [aws_security_group.database.id]
  parameter_group_name   = aws_db_parameter_group.flowable_db_oe.name
  publicly_accessible    = false
  skip_final_snapshot    = true
}

resource "aws_security_group" "database" {
  name_prefix = "flowable-db"
  vpc_id      = var.vpc_id

  ingress {
    from_port   = 1521
    to_port     = 1521
    protocol    = "tcp"
    cidr_blocks = ["${var.vpc_cidr_block}"]
  }

  egress {
    from_port   = 1521
    to_port     = 1521
    protocol    = "tcp"
    cidr_blocks = ["0.0.0.0/0"]
  }

}

data "aws_secretsmanager_secret_version" "flowable_db_auth" {
  secret_id = var.aws_secret_flowable_db_auth_id
}