/**
  * # AWS - K8s - Ingres Nginx Controller
  * 
  * This is a Terraform module for deploying the [Ingress Nginx Controller](https://kubernetes.github.io/ingress-nginx/) on Elastic Kubernetes Service (EKS).
  * See the documentation below for additional info on using this module.
  */

provider "kubernetes" {
  host                   = data.aws_eks_cluster.eks.endpoint
  cluster_ca_certificate = base64decode(data.aws_eks_cluster.eks.certificate_authority[0].data)
  token                  = data.aws_eks_cluster_auth.eks.token
}

provider "helm" {
  kubernetes {
    host                   = data.aws_eks_cluster.eks.endpoint
    cluster_ca_certificate = base64decode(data.aws_eks_cluster.eks.certificate_authority[0].data)
    token                  = data.aws_eks_cluster_auth.eks.token
  }
}

data "aws_eks_cluster" "eks" {
  name = var.cluster_name
}

data "aws_eks_cluster_auth" "eks" {
  name = var.cluster_name
}

resource "kubernetes_namespace" "ingress" {
  metadata {
    name = "ingress"
  }
}

resource "helm_release" "nginx_ingress" {
  depends_on = [kubernetes_namespace.ingress]
  name       = "nginx-ingress-controller"

  repository = "https://charts.bitnami.com/bitnami"
  chart      = "nginx-ingress-controller"

  namespace = "ingress"

  values = [
    "${var.values}"
  ]
}

data "kubernetes_service" "ingress_controller" {
  depends_on = [
    helm_release.nginx_ingress
  ]
  metadata {
    name = "nginx-ingress-controller"
    namespace = "ingress"
  }
}