<!-- BEGIN_TF_DOCS -->
## Requirements

| Name | Version |
|------|---------|
| <a name="requirement_terraform"></a> [terraform](#requirement\_terraform) | >= 1.0.0 |
| <a name="requirement_aws"></a> [aws](#requirement\_aws) | ~> 3.74.0 |
| <a name="requirement_kubernetes"></a> [kubernetes](#requirement\_kubernetes) | ~> 2.7.1 |

## Providers

| Name | Version |
|------|---------|
| <a name="provider_aws"></a> [aws](#provider\_aws) | ~> 3.74.0 |
| <a name="provider_kubernetes"></a> [kubernetes](#provider\_kubernetes) | ~> 2.7.1 |

## Resources

| Name | Type |
|------|------|
| [kubernetes_namespace.flowable](https://registry.terraform.io/providers/hashicorp/kubernetes/latest/docs/resources/namespace) | resource |
| [kubernetes_role.flowable_dev_role](https://registry.terraform.io/providers/hashicorp/kubernetes/latest/docs/resources/role) | resource |
| [kubernetes_role.flowable_operator_role](https://registry.terraform.io/providers/hashicorp/kubernetes/latest/docs/resources/role) | resource |
| [kubernetes_role_binding.flowable_dev_role_binding](https://registry.terraform.io/providers/hashicorp/kubernetes/latest/docs/resources/role_binding) | resource |
| [kubernetes_role_binding.flowable_operator_role_binding](https://registry.terraform.io/providers/hashicorp/kubernetes/latest/docs/resources/role_binding) | resource |
| [kubernetes_secret.flowable_db_creds](https://registry.terraform.io/providers/hashicorp/kubernetes/latest/docs/resources/secret) | resource |
| [kubernetes_secret.flowable_docker_auth](https://registry.terraform.io/providers/hashicorp/kubernetes/latest/docs/resources/secret) | resource |
| [kubernetes_secret.flowable_license](https://registry.terraform.io/providers/hashicorp/kubernetes/latest/docs/resources/secret) | resource |
| [kubernetes_storage_class.efs_sc_dyn](https://registry.terraform.io/providers/hashicorp/kubernetes/latest/docs/resources/storage_class) | resource |
| [aws_eks_cluster.eks](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/eks_cluster) | data source |
| [aws_eks_cluster_auth.eks](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/eks_cluster_auth) | data source |
| [aws_secretsmanager_secret_version.flowable_db_auth](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/secretsmanager_secret_version) | data source |
| [aws_secretsmanager_secret_version.flowable_license](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/secretsmanager_secret_version) | data source |
| [aws_secretsmanager_secret_version.flowable_repo_auth](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/data-sources/secretsmanager_secret_version) | data source |

## Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:--------:|
| <a name="input_namespace"></a> [namespace](#input\_namespace) | Name of the namespace where the resources will reside | `string` | n/a | yes |
| <a name="input_cluster_name"></a> [cluster\_name](#input\_cluster\_name) | Then name of kubernetes cluster | `string` | n/a | yes |
| <a name="input_flowable_docker_registry_server"></a> [flowable\_docker\_registry\_server](#input\_flowable\_docker\_registry\_server) | The Flowable docker registry server | `string` | `"artifacts.flowable.com"` | no |
| <a name="input_flowable_repo_username"></a> [flowable\_repo\_username](#input\_flowable\_repo\_username) | The Flowable docker registry username which can be used to override `keyvault_secret_name_flowable_repo_username` | `string` | `""` | no |
| <a name="input_flowable_repo_password"></a> [flowable\_repo\_password](#input\_flowable\_repo\_password) | The Flowable docker registry password which can be used to override `keyvault_secret_name_flowable_repo_password` | `string` | `""` | no |
| <a name="input_flowable_db_username"></a> [flowable\_db\_username](#input\_flowable\_db\_username) | The Flowable docker registry username which can be used to override `keyvault_secret_name_flowable_db_username` | `string` | `""` | no |
| <a name="input_flowable_db_password"></a> [flowable\_db\_password](#input\_flowable\_db\_password) | The Flowable docker registry password which can be used to override `keyvault_secret_name_flowable_db_password` | `string` | `""` | no |
| <a name="input_secret_name_docker_auth"></a> [secret\_name\_docker\_auth](#input\_secret\_name\_docker\_auth) | Name of the Kubernetes secret which holds the Docker registry authentication | `string` | n/a | yes |
| <a name="input_secret_name_flowable_license"></a> [secret\_name\_flowable\_license](#input\_secret\_name\_flowable\_license) | Name of the Kubernetes secret that will be created to store the Flowable license | `string` | n/a | yes |
| <a name="input_aws_secret_flowable_repo_auth_id"></a> [aws\_secret\_flowable\_repo\_auth\_id](#input\_aws\_secret\_flowable\_repo\_auth\_id) | ID (ARN) of the AWS secret that will be used to fetch the Flowable repository authentication related credentials and settings | `string` | n/a | yes |
| <a name="input_aws_secret_flowable_db_auth_id"></a> [aws\_secret\_flowable\_db\_auth\_id](#input\_aws\_secret\_flowable\_db\_auth\_id) | ID (ARN) of the AWS secret that will be used to fetch the Flowable db authentication related credentials and settings | `string` | n/a | yes |
| <a name="input_aws_secret_flowable_repo_username_key"></a> [aws\_secret\_flowable\_repo\_username\_key](#input\_aws\_secret\_flowable\_repo\_username\_key) | Name of the key in the AWS secret which holds the Flowable repository username | `string` | n/a | yes |
| <a name="input_aws_secret_flowable_repo_password_key"></a> [aws\_secret\_flowable\_repo\_password\_key](#input\_aws\_secret\_flowable\_repo\_password\_key) | Name of the key in the AWS secret which holds the Flowable repository password | `string` | n/a | yes |
| <a name="input_aws_secret_flowable_license_id"></a> [aws\_secret\_flowable\_license\_id](#input\_aws\_secret\_flowable\_license\_id) | ID (ARN) of the AWS secret that will be used to fetch the Flowable license | `string` | n/a | yes |
| <a name="input_aws_secret_flowable_license_key"></a> [aws\_secret\_flowable\_license\_key](#input\_aws\_secret\_flowable\_license\_key) | Name of the key in the AWS secret which holds the Flowable license | `string` | n/a | yes |
| <a name="input_efs_file_system_id"></a> [efs\_file\_system\_id](#input\_efs\_file\_system\_id) | The ID of the EFS file system used for creating a storage class | `string` | n/a | yes |

## Outputs

No outputs.
<!-- END_TF_DOCS -->