variable "cluster_name" {
  description = "Name of the Kubernetes cluster"
  type        = string
}

variable "aws_secret_flowable_repo_auth_id" {
  description = "ID (ARN) of the AWS secret that will be used to fetch the Flowable repository authentication related credentials and settings"
  type = string
}

variable "aws_secret_flowable_db_auth_id" {
  description = "ID (ARN) of the AWS secret that will be used to fetch the Flowable DB authentication related credentials and settings"
  type = string
}

variable "release_name" {
  description = "Name of the Helm release"
  type        = string
}

variable "release_namespace" {
  description = "Namespace of the  Helm release"
  type        = string
}

variable "chart_name" {
  description = "Name of the Flowable Helm chart"
  type        = string
}

variable "chart_version" {
  description = "Version of the Flowable Helm chart"
  type        = string
}

variable "create_namespace" {
  description = "Create release namespace"
  default     = "true"
  type        = string
}

variable "helm_repo_url" {
  description = "Flowable Helm repository url"
  default     = "https://artifacts.flowable.com/artifactory/helm-product"
  type        = string
}

variable "values" {
  description = "The Flowalbe Helm chart values in (yaml format). See https://code.flowable.com/flw-lic/flowable-product/flowable-iac/flowable-iac-helm for more information"
  type        = string
}
