# Include the root terragrunt `root.hcl` configuration. The root configuration contains settings that are common across all
# components and environments, such as how to configure remote state.
include {
  path = find_in_parent_folders("root.hcl")
}

# We override the terraform block source attribute here just for the QA environment to show how you would deploy a
# different version of the module in a specific environment.
terraform {
  # source = "${local.base_source_url}"
  # source = "${local.base_source_url}?ref=v0.4.0"
  source = "../../../../../../../flowable-iac-modules-aws//k8s/k8s-config"
}

locals {
  # Expose the base source URL so different versions of the module can be deployed in different environments.
  base_source_url = "git@code.flowable.com:flw-lic/flowable-product/flowable-iac/flowable-iac-modules-aws.git//k8s/k8s-config"
}

dependency "eks_cluster" {
  config_path = "../eks-cluster"
}

dependency "efs" {
  config_path = "../../efs"
}

inputs = {
  cluster_name                          = dependency.eks_cluster.outputs.cluster_name
  cluster_oidc_issuer_arn               = dependency.eks_cluster.outputs.cluster_oidc_issuer_arn
  cluster_oidc_issuer_url               = dependency.eks_cluster.outputs.cluster_oidc_issuer_url
  efs_file_system_id                    = dependency.efs.outputs.efs_file_system_id
  aws_secret_flowable_repo_username_key = "flowable_repo_username"
  aws_secret_flowable_repo_password_key = "flowable_repo_password"
  aws_secret_flowable_license_key       = "flowable_license"
  secret_name_docker_auth               = "flowable-iac-flowable-regcred"
  secret_name_flowable_license          = "flowable-iac-flowable-license"
}