# Include the root terragrunt `root.hcl` configuration. The root configuration contains settings that are common across all
# components and environments, such as how to configure remote state.
include "root" {
  path = find_in_parent_folders("root.hcl")
  expose = true
}

# We override the terraform block source attribute here just for the QA environment to show how you would deploy a
# different version of the module in a specific environment.
terraform {
  # source = "${local.base_source_url}"
  # source = "${local.base_source_url}?ref=v0.4.0"
  source = "../../../../../../../flowable-iac-modules-aws//k8s/eks-cluster"
}

locals {
  # Expose the base source URL so different versions of the module can be deployed in different environments.
  base_source_url = "git@code.flowable.com:flw-lic/flowable-product/flowable-iac/flowable-iac-modules-aws.git//k8s/eks-cluster"
}

dependency "vpc" {
  config_path = "../../vpc"
}

inputs = {
  vpc_id                        = dependency.vpc.outputs.vpc_id
  vpc_private_subnets           = dependency.vpc.outputs.vpc_private_subnets
  worker_group_instance_type    = "t3a.medium"
  worker_group_desired_capacity = 3
  additional_map_roles          = [
                                    {
                                      rolearn  = "${include.root.locals.dev_ops_admin_role_arn}"
                                      username = "dev_ops_admin"
                                      groups   = ["system:masters"]
                                    },
                                    {
                                      rolearn  = "${include.root.locals.flowable_admin_role_arn}"
                                      username = "flowable_admin"
                                      groups   = ["flowable-admin"]
                                    },
                                    {
                                      rolearn  = "${include.root.locals.flowable_dev_role_arn}"
                                      username = "flowable_dev"
                                      groups   = ["flowable-dev"]
                                    }
                                  ]
}
  