variable "es_domain_name_prefix_override" {
  description = "Override the Elasticsearch domain name prefix (by default full_workload variable will be used as a prefix)"
  type = string
  default = ""
}

variable "full_workload" {
  description = "The full workload name (workload and environment suffix)"
  type = string
}

variable "vpc_id" {
    description = "The ID of the VPC"
    type = string
}

variable "vpc_cidr_block" {
    description = "The CIDR block of the VPC"
    type = string
}

variable "vpc_private_subnets" {
    description = "The private subnets of the VPC"
    type = list(string)
}

variable "es_enabled" {
    description = "Flag wether Elasticsearch is enabled or not"
    type = bool
}

variable "es_cluster_instance_count" {
    description = "The number of instances in this ES cluster"
    type = number
    default = 3
}

variable "es_cluster_instance_type" {
    description = "The instance type in this ES cluster"
    type = string
    default = "t3.medium.elasticsearch"
}